DEFINT A-Z
CONST TermName$ = "64 BlazerTerm"   'TermName$ is the name of this term,
CONST TermFile$ = "64BLAZER"        'TermFile$ is the filename of this term,
CONST Version$ = "v0.77"            'Version$ is the version of this term.
CONST TermDate$ = "1992, 1993"       'TermDate$ is the date of this version.

'$INCLUDE: '64blaz.bi'      To include the file for declaring routines

DECLARE SUB TRead (Messg$)          'Modem recieve buffer string read
DECLARE SUB ReadCommand (Parm$)     'Command-line parms reader
DECLARE SUB TTY (Char%)             'TTY writing subroutine, with advance
DECLARE SUB TTYStay (Char%, Attr%)  'TTY writing subroutine without advance
DECLARE SUB TTYCR ()                'TTY write of Carraige Return code
DECLARE SUB Init64Set ()            'Reads the C64 char set from file
DECLARE SUB Load64Set (Set%)        'Loads into VGA RAM the C64 set
DECLARE SUB Set64Screen ()          'Sets the 'C64 screen mode'
DECLARE SUB RestorePC ()            'Restores the 'IBM screen mode'
DECLARE SUB EndProg ()              'Ends program, with deinitialization
DECLARE SUB CursorBlink (Status%)   'Blinks the cursor in the terminal
DECLARE SUB ChangeColr (SetColr%)   'Changes the cursor color
DECLARE SUB Out64 (Char%)           'Outputs CBMASCII codes to the screen
DECLARE FUNCTION Code64% (Char$)    'Translates IBMASCII to CBMASCII
DECLARE FUNCTION TimeDiff& (Mark&)  'Tells time difference between now and
				    'the time in Mark&, in no. of seconds
				    'multiplied by 100 (to prevent the use
				    'of real numbers)
DECLARE FUNCTION Time& ()           'Returns no. of seconds, multiplied by
				    '100, since midnight (no real numbers!)
DECLARE SUB ClearBlk (BTop%, BLeft%, BBot%, BRight%, BFore%, BBack%)
				    'Clears a block on the screen
DECLARE SUB DispMsg (Msg$, MFore%, MBack%, Delay&)   'Displays IBMASCII
			     'message in CBMASCII on the screen, with
			     'a box, and delay flag for keypress pause
DECLARE SUB PrintLoc (Msg$)  'IBMASCII message in CBMASCII, on the screen.
DECLARE SUB Waitt (Delay&, Keyy%)   'Delaying subroutine, with optional
				    'keypress interruption of delay
DECLARE SUB GetaKey (Keyy$)         'Waits for a keypress, and returns it
DECLARE SUB CheckKey (KeyP$)        'Checks keypress for terminal-function
				    'keypress (ie local echo) and execute it
DECLARE SUB AutoDial ()             'Automatic redialer subroutine
DECLARE SUB InitXLatKeys ()         'Initialization of IBM to C64 keyboard
				    'translation table
DECLARE SUB XmodemRec ()            'Xmodem download subroutine
DECLARE SUB XmodemSend ()           'Xmodem upload subroutine
DECLARE SUB XMessage (MsgNum%)      'Xmodem status message
DECLARE SUB XUpdate (FilePos&)      'Xmodem status window update
DECLARE SUB XInitWin ()             'Xmodem status window initialization
DECLARE SUB XAskFile ()             'File transfer filename input subroutine
DECLARE SUB Get40 (CurFlag%)        'Screen preserver (nonzero CurFlag% saves
				    'cursor too) ie. before a DOS shell
DECLARE SUB Put40 (CurFlag%)        'Screen restore (nonzero CurFlag% restores
				    'cursor too) ie. after a DOS shell
DECLARE FUNCTION CCap$ (Strg$)      'String capitalization, so always in caps
				    'regardless of the current C64 char set
DECLARE SUB Set40Mode ()            'Sets 40 column text mode
DECLARE SUB SetBordColr (Attr%)     'Sets the border color
DECLARE SUB Set64Palette ()         'Detects palette ability and sets the
				    'palette to resemble C64 colors.
DECLARE SUB Palet (Attr%, Red%, Green%, Blue%)
				    'Palette setter for VGA palette
DECLARE SUB SavePalet ()            'Saves initial palette (VGA only)
DECLARE SUB RestorePalet ()         'Restores initial palette
DECLARE SUB Backscroll ()           'View the backscroll buffer
DECLARE SUB AddBackScroll (RowNum%) 'Add a line to the backscroll buffer

'The following is the file that holds the Commodore 64 character font data.
CONST CharSetFile$ = "CHARSET.C64"
CONST ConnectMus$ = "MBL4O1E"  'The sound played when the modem connects.
CONST Bing$ = "MBL12O1D"        'The sound played with Ctrl-G bing
CONST Bong$ = "MBL12O3A"        'The sound played with Ctrl-V bong
CONST NoteLimit% = 10        'Maximum number of notes in music buffer
CONST HangUp$ = "ATH0"       'The hangup string for the modem.
CONST DialPref$ = "ATDT"     'The dialing prefix for the modem.
CONST DialLen% = 40          'The maximum length for the phone to ring.
			     'In exact number of seconds (not times 100)
CONST DialPause& = 100       'The delay before redialing phone number. (secs)
CONST DefaultParm$ = "8N1"   'The default modem parameters
CONST DefaultBaud& = 2400    'The default modem baud rate
CONST InitBack% = 0          'Background color at start of program
CONST InitColr% = 13         'Cursor color at start of program

'The following declares the public global arrays to be used in this program.
'INCLUDE: '64DECLAR.BI'
DIM SHARED FKey%(255), NormKey%(255), CmKey%(255), Outt%(255)
DIM SHARED Pal%(15), CxPalSave%(15), DxPalSave%(15)
COMMON SHARED FKey%(), NormKey%(), CmKey%(), Outt%()
COMMON SHARED Pal%(), CxPalSave%(), DxPalSave%()
COMMON SHARED Scrn AS STRING * 2080
COMMON SHARED CharSet AS STRING * 4096
DIM SHARED LineBuff AS STRING * 80
'CharSet holds the entire 2 Commodore 64 character sets,
'LineBuff is used in output routines for the insertion of a space in text,
'Scrn is used for screen saving/restoring such as before/after a DOS shell,
'FKey% is the translation table for the function keys,
'NormKey% is the translation table for most of the keyboard, IBM to C64 codes,
'CmKey% is the translation table for the 'C='-combination emulation,
'Pal% is the C64 palette table.
'CxPalSave% and DxPalSave% is the table of VGA palette values which is
'           saved at the beginning of the program and restored at the end.

CLEAR , , 2048            'Reserve 2048 bytes of stack space for this program

'The following is the variable initialization for this program.
Baud& = DefaultBaud&   'Set the default baud rate
Parm$ = DefaultParm$   'Set default modem parameters
CursorEnable% = -1     'Enable cursor blinking
CurBlinkin% = 0        'Flag representing cursor has blinked off (not on)
CurBlinkLim& = 33      'Frequency of the cursor toggling its blink (1/3 sec)

'The following declares defaults in the public variables.
Wid% = 40
Height% = 25
Row% = 1
Col% = 1
Colr% = InitColr%
Back% = InitBack%
Bord% = 14
echo% = 0
Tabb% = 0
ChgBack% = 0
Portt% = 1
Buff% = 1
BackLine% = 0

'The following reads the command-line options.
ReadCommand COMMAND$

'The following calls the subroutine that fills the IBM-to-Commodore 64
'code keyboard translation table.
InitXLatKeys

'The following initializes the modem, and prints an error message if
'there was a problem in initializing it, such as the wrong COM port.
TCInit Portt%, 1024, 1024, Er%
IF Er% THEN
  TCDone
  CLS
  PRINT
  PRINT "An error has occured in an attempt to access the modem. There"
  PRINT "may not be enough memory for this program to run. Please try"
  PRINT "deinstalling TSRs first, or you may have tried accessing the"
  PRINT "wrong COM port. Type '"; TermFile$; " ?' at the DOS command-line for"
  PRINT "a list of command-line options, including setting the correct"
  PRINT "COM port."
  PRINT
  PRINT "If the above fails, send Internet E-mail to marky@ottawa.com"
  END
END IF

'The following initializes the modem speed and parameters
TCSpeed Baud&
TCParms MID$(Parm$, 2, 1), VAL(LEFT$(Parm$, 1)), VAL(RIGHT$(Parm$, 1))

'The following initializes the Commodore 64 character set.
Init64Set

'The following sets the background and border color.
COLOR Colr%
Out64 147
SetBordColr Bord%

'The following prints the terminal name, programmers' names, and the
'initial baud rate, and help on configuration/getting the help screen.
Msg$ = TermName$ + " " + Version$ + CHR$(13) + TermDate$ + " by Mark D. Rejhon" + CHR$(13) + "With help by Roy M. Hooper" + CHR$(13) + CHR$(13)
PrintLoc Msg$
Msg$ = LTRIM$(STR$(Baud&)) + " baud set, Alt-B to change." + CHR$(13) + "Hit Alt-Z for help on more options!" + CHR$(13) + CHR$(13)
PrintLoc Msg$

'The initialization ends here. The following is the main program loop.
'Most of this program is in subroutines.
DO
  KeyP$ = INKEY$
  IF LEN(KeyP$) THEN
    CheckKey KeyP$
    IF KeyP$ = "xx" THEN EXIT DO
    IF LEN(KeyP$) THEN
      keypress% = Code64%(KeyP$)
      TCWrite CHR$(keypress%)
      IF echo% THEN Out64 keypress%
    END IF
  END IF
  TRead Recieve$
  IF LEN(Recieve$) THEN
    FOR PrintRec% = 1 TO LEN(Recieve$)
      Out64 ASC(MID$(Recieve$, PrintRec%))
    NEXT PrintRec%
  ELSE
    IF TimeDiff&(CurBlinkTime&) > CurBlinkLim& THEN CursorBlink -1
  END IF
LOOP

'The following de-initializes the modem and restores the IBM screen.
QuitProg:
RestorePC
TCDone
Regs.ax = &H3
Regs.bx = &H0
Regs.cx = &H0
Regs.dx = &H0
interrupt &H10, Regs, Regs

'The following prints the thank-you/registration screen.
PRINT "Thank you for using "; TermName$; " "; Version$; "!"
PRINT "Copyright "; TermDate$; " by Mark Rejhon, All rights reserved."
PRINT
PRINT "If you like "; TermName$; " program, or use it at least occasionally,"
PRINT "PLEASE mail a postcard to the following address:"
PRINT
PRINT "                     Mark Rejhon"
PRINT "                     433 Besserer Drive, Apt #7"
PRINT "                     Ottawa, Ont, Canada"
PRINT "                     K1N 6B9                          ...Thank You! :-)"
PRINT
PRINT "This program used to be shareware.  I have now released this program as"
PRINT "freeware.  The source code is available for free under these conditions:"
PRINT
PRINT "   Profits: You may not charge $$$ for 64 BlazerTerm or a modified verison."
PRINT "   Credits: You display a credits screen containing my name and E-mail address."
PRINT
PRINT "To contact Mark Rejhon, you can contact him by:"
PRINT
PRINT "   Internet: marky@ottawa.com                (Permanent E-mail address)"
PRINT "        WWW: http://www.marky.com/           (Website may not be up yet)"
END
'This is the end of the program.

'The following is the data for the pop-up help screen.
HelpData:
DATA "Shift-Tab","Switch character sets"
DATA "Alt-E", "Toggle half/full duplex"
DATA "Alt-D", "Automatic dialer
DATA "Alt-H", "Hang up"
DATA "Alt-O", "Change COM port"
DATA "Alt-P", "Select N81 or E71"
DATA "Alt-B", "Change Baud rate"
DATA "Alt-Z", "This help screen"
DATA "Alt-J", "DOS shell to PC"
DATA "Alt-X", "Exit 64 BlazerTerm"
DATA "Alt-C", "Clear/Reset screen"
DATA "Alt-A", "Change background color"
DATA "Alt-S", "Change border color"
DATA "Alt-R", "Read backscroll buffer"
DATA "PageDn", "Xmodem Download"
DATA "PageUp", "Xmodem Upload"
DATA ".",

'The following is an error-handler, which occurs when the OPEN statement
'elsewhere in the program produces an error (a file nonexistence error,
'for example), goes here, sets an error flag, and returns execution.
BadFile:
FileErr% = -1
RESUME NEXT

SUB AutoDial
  DFore% = 15
  DBack% = 6
  DCol1% = 15
  DCol2% = 1
  Msg$ = "Number to dial:"
  ClearBlk 11, 3, 13, 38, DFore%, DBack%
  Print64 12, 4, Fo(DFore%) + Ba(DBack%) + CCap$(Msg$)
  LLeft% = 4 + LEN(Msg$)
  Print64 12, LLeft% + 1, CCap$(Num$)
  Offs% = LEN(Num$) + 1
  LOCATE 12, LLeft% + Offs%, 1, 0, 7
  Maxx% = 18
  DO
    GetaKey Keyy$
    IF Keyy$ >= " " AND Keyy$ <= "~" AND Offs% <= Maxx% THEN
      Print64 12, LLeft% + Offs%, CCap$(Keyy$)
      LOCATE , LLeft% + Offs% + 1
      Num$ = Num$ + Keyy$
      Offs% = Offs% + 1
    ELSEIF Keyy$ = CHR$(8) AND Offs% > 1 THEN
      Num$ = LEFT$(Num$, LEN(Num$) - 1)
      Offs% = Offs% - 1
      Print64 12, LLeft% + Offs%, " "
      LOCATE , LLeft% + Offs%
    ELSEIF Keyy$ = CHR$(13) THEN
      EXIT DO
    ELSEIF Keyy$ = CHR$(27) THEN
      LOCATE , , 0, 9, 9
      EXIT SUB
    END IF
  LOOP
  LOCATE , , 0, 9, 9
  Keye$ = ""
  IF LEN(Num$) THEN
    Put40 0
    ClearBlk 9, 5, 15, 36, DFore%, DBack%
    Attempt% = 0
    Print64 14, 17, Fo(DCol2%) + CCap$("none")
    Print64 12, 8, Fo(DCol1%) + CCap$("attempt: ")
    Print64 12, 26, CCap$("time: ")
    Print64 14, 8, CCap$("message: ")
    Connected% = 0
    DO
      Print64 10, 8, Fo(DCol1%) + CCap$("dialing: ")
      Print64 10, 17, Fo(DCol2%) + CCap$(Num$)
      Attempt% = Attempt% + 1
      Print64 12, 16, STR$(Attempt%)
      Print64 12, 32, "0   "
      TCWrite DialPref$ + Num$ + CHR$(13)
      Waitt 15, 0           '.15 second
      DO
	Keye$ = INKEY$
	IF Keye$ = CHR$(27) THEN EXIT DO
      LOOP UNTIL Keye$ = ""
      DTime& = Time&
      Eatt& = Time&
      DO
	TRead Char$
	IF LEN(Char$) THEN Eatt& = Time&
      LOOP UNTIL TimeDiff&(Eatt&) > 50        '.5 second
      MMsg$ = ""
      IF TimeDiff&(DTime&) > 1 THEN DTime& = Time& - 100  '1 second ago
      DO
	Elapse% = TimeDiff&(DTime&) / 100
	IF Keye$ <> CHR$(27) THEN Keye$ = INKEY$
	SELECT CASE Keye$
	CASE CHR$(27)
	  Print64 14, 17, CCap$("abort               ")
	  TCFlushIn
	  TCWrite CHR$(13)
	  Waitt 150, 1        '1.5 seconds
	  EXIT SUB
	CASE CHR$(13)
	  Print64 14, 17, CCap$("break               ")
	  TCFlushIn
	  Waitt 150, 1        '1.5 seconds
	  EXIT SUB
	CASE " "
	  Print64 10, 8, CCap$("pausing...                  ")
	  Print64 14, 17, CCap$("recycle             ")
	  TCFlushIn
	  TCWrite CHR$(13)
	  Print64 12, 32, "0   "
	  Waitt DialPause&, 0
	  Eatt& = Time&
	  DO
	    TRead Char$
	    IF LEN(Char$) THEN Eatt& = Time&
	  LOOP UNTIL TimeDiff&(Eatt&) > 50   '.5 second
	  TCFlushIn
	  EXIT DO
	END SELECT
	IF Elapse% > DialLen% THEN
	  Print64 14, 17, CCap$("timeout             ")
	  EXIT DO
	END IF
	Print64 12, 31, STR$(Elapse%)
	TRead Char$
	IF LEN(Char$) THEN
	  Messg& = Time&
	  MMsg$ = MMsg$ + Char$
	ELSE
	  IF TimeDiff&(Messg&) > 40 THEN      '.4 second
	    IF LEN(MMsg$) THEN
	      Ptr% = 1
	      DO
		Temp% = ASC(MID$(MMsg$, Ptr%, 1))
		IF Temp% < 32 OR Temp% > 126 THEN
		  MMsg$ = LEFT$(MMsg$, Ptr% - 1) + MID$(MMsg$, Ptr% + 1)
		ELSE
		  Ptr% = Ptr% + 1
		END IF
	      LOOP UNTIL Ptr% > LEN(MMsg$)
	      Print64 14, 17, CCap$(LEFT$(LCASE$(MMsg$) + SPACE$(20), 20))
	      IF INSTR(UCASE$(MMsg$), "CONNECT") THEN
		Connected% = -1
	      ELSE
		Print64 10, 8, CCap$("pausing...                  ")
		TCFlushIn
		TCWrite CHR$(13)
		Print64 12, 32, "0   "
		Waitt DialPause&, 0
		Eatt& = Time&
		DO
		  TRead Char$
		  IF LEN(Char$) THEN Eatt& = Time&
		LOOP UNTIL TimeDiff&(Eatt&) > 50       '.5 second
		TCFlushIn
	      END IF
	      EXIT DO
	    END IF
	  END IF
	END IF
      LOOP
    LOOP UNTIL Connected%
    PLAY ConnectMus$
    Waitt 200, 1          '2 seconds
  END IF
END SUB

SUB CheckKey (KeyP$)
  IF LEFT$(KeyP$, 1) = CHR$(0) THEN
    SELECT CASE RIGHT$(KeyP$, 1)
    CASE ""     'Shift-Tab Change character sets
      Set% = Set% XOR 1
      Load64Set Set%
      KeyP$ = ""
    CASE "."     'Alt-C Forced clear screen
      Row% = 1
      Col% = 1
      Back% = InitBack%
      Colr% = InitColr%
      ClearBlk 1, 1, 25, 80, Colr%, Back%
      CurBlinkin% = 0
      LOCATE Row%, Col%
      CurBlinkTime& = 0
      KeyP$ = ""
    CASE CHR$(30)   'Alt-A Change background color
      Back% = (Back% + 1) AND 15
      Background Back%
      KeyP$ = ""
    CASE CHR$(31)   'Alt-S Change border color
      Bord% = (Bord% + 1) AND 15
      SetBordColr Bord%
      KeyP$ = ""
    CASE ""     'Alt-E Toggle echo
      CursorBlink 0
      echo% = NOT echo%
      IF echo% THEN
	DispMsg "Half-Duplex mode", 7, 6, 200        '2 seconds
      ELSE
	DispMsg "Full-Duplex mode", 7, 6, 200        '2 seconds
      END IF
      KeyP$ = ""
      CurBlinkTime& = 0
    CASE ""     'Alt-O Change COM port
      CursorBlink 0
      DispMsg "Hit (1),(2),(3) or (4) for COM port", 0, 15, 0
      GetaKey Keyy$
      Put40 1
      IF VAL(Keyy$) >= 1 AND VAL(Keyy$) <= 4 THEN
	TCDone
	Portt% = VAL(Keyy$)
	TCInit Portt%, 1024, 1024, Er%
	DispMsg "COM port is now " + Keyy$, 0, 15, 200         '2 seconds
      END IF
      CurBlinkTime& = 0
      KeyP$ = ""
    CASE "0"     'Alt-B Change Baud rate
      CursorBlink 0
      DispMsg "Hit (3)00 (1)200 or (2)400 baud ", 0, 15, 0
      GetaKey Keyy$
      Put40 1
      Keyy% = VAL(Keyy$)
      IF Keyy% = 1 OR Keyy% = 2 OR Keyy% = 3 THEN
	SELECT CASE Keyy%
	CASE 1: Baud& = 1200
	CASE 2: Baud& = 2400
	CASE 3: Baud& = 300
	END SELECT
	TCSpeed Baud&
	DispMsg "Baud Rate is now" + STR$(Baud&), 0, 15, 200      '2 seconds
      END IF
      CurBlinkTime& = 0
      KeyP$ = ""
    CASE ""     'Alt-P Change port parameters
      CursorBlink 0
      DispMsg "Hit (1)8N1 or (2)7E1 for parameter", 0, 15, 0
      GetaKey Keyy$
      Put40 1
      Keyy% = VAL(Keyy$)
      IF Keyy% = 1 OR Keyy% = 2 THEN
	SELECT CASE Keyy%
	CASE 1: Parm$ = "8N1"
	CASE 2: Parm$ = "7E1"
	END SELECT
	TCParms MID$(Parm$, 2, 1), VAL(LEFT$(Parm$, 1)), VAL(RIGHT$(Parm$, 1))
	DispMsg "Parameter is now " + Parm$, 0, 15, 200        '2 seconds
      END IF
      CurBlinkTime& = 0
      KeyP$ = ""
    CASE ""     'Alt-R Backsrcroll Buffer
      CursorBlink 0
      Get40 1
      Backscroll
      Put40 1
      CurBlinkTime& = 0
      KeyP$ = ""
    CASE " "     'Alt-D Redialer
      CursorBlink 0
      Get40 1
      AutoDial
      Put40 1
      CurBlinkTime& = 0
      KeyP$ = ""
    CASE "#"     'Alt-H Hang up
      CursorBlink 0
      DispMsg "HANG UP: Are you sure? Y/N", 7, 2, 0
      GetaKey Keyy$
      IF UCASE$(Keyy$) = "Y" THEN
	Print64 12, 8, CCap$("{A}B       hanging up...      ")
	TCDTR 0
	Waitt 150, 0        '1.5 seconds
	TCDTR 1
	IF TCCarrier% THEN
	  TCWrite "+++"
	  Waitt 150, 0      '1.5 seconds
	  TCWrite HangUp$ + CHR$(13)
	  Waitt 50, 0       '.5 second
	END IF
      END IF
      Put40 1
      CurBlinkTime& = 0
      KeyP$ = ""
    CASE "$"     'Alt-J Dos shell
      CursorBlink 0
      Get40 1
      RestorePC
      PRINT
      PRINT "***** Type EXIT to return to "; TermName$; ". *****";
      SHELL
      Set64Screen
      Put40 1
      CurBlinkTime& = 0
      KeyP$ = ""
    CASE "I"     'PageUp Xmodem Upload
      CursorBlink 0
      Get40 1
      XFer% = 1
      XmodemSend
      Put40 1
      CurBlinkTime& = 0
      KeyP$ = ""
    CASE "Q"     'PageDown Xmodem Download
      CursorBlink 0
      Get40 1
      XFer% = -2
      XmodemRec
      Put40 1
      CurBlinkTime& = 0
      KeyP$ = ""
    CASE ","     'Alt-Z Help
      CursorBlink 0
      Get40 1
      COLOR , 0
      CLS
      SetBordColr 0
      Load64Set 1
      TitCl% = 10
      Cl% = 1
      Cl2% = 11
      Cl3% = 15
      Cl4% = 15
      Cl5% = 7
      KeyCl% = 13
      DO
	Message$ = TermName$ + " Pop-Up Help screen"
	Print64 1, 21 - LEN(Message$) / 2, Fo(TitCl%) + "}0" + Message$
	Print64 2, 1, " Copyright " + TermDate$ + " by Mark D. Rejhon "
	Row% = 4
	RESTORE HelpData
	DO
	  READ HKey$, HDesc$
	  IF HKey$ <> "." THEN
	    Ln$ = Fo(Cl%) + HKey$
	    Ln$ = Ln$ + Fo(Cl2%) + STRING$(34 - LEN(HKey$) - LEN(HDesc$), "-")
	    Ln$ = Ln$ + Fo(Cl3%) + HDesc$
	    Print64 Row%, 4, Ln$
	    Row% = Row% + 1
	  END IF
	LOOP UNTIL HKey$ = "."
	Print64 25, 1, Fo(KeyCl%) + "*** Esc to exit Help, Space for More ***"
	DO
	  GetaKey Keyy$
	LOOP UNTIL Keyy$ = CHR$(27) OR Keyy$ = CHR$(13) OR Keyy$ = " "
	IF Keyy$ = CHR$(27) THEN EXIT DO
	CLS
	Print64 1, 9, Fo(TitCl%) + "C= 64 Keyboard emulation"
	Print64 3, 3, Fo(Cl%) + "Shift" + Fo(Cl2%) + "-" + Fo(Cl3%) + "Functionally similiar to the"
	Print64 4, 3, "      COMMODORE 64's Shift key."
	Print64 5, 3, Fo(Cl%) + "Tab" + Fo(Cl2%) + "---" + Fo(Cl3%) + "This key emulates the C= key."
	Print64 6, 3, "      Hit Tab once then hit any key"
	Print64 7, 3, "      on your keyboard, to display"
	Print64 8, 3, "      graphic characters."
	Print64 9, 3, Fo(Cl%) + "Ctrl-F1 to Ctrl-F10" + Fo(Cl2%) + "---------------" + Fo(Cl3%)
	Print64 10, 3, "      Replaces the Ctrl-Number key"
	Print64 11, 3, "      combinations for producing"
	Print64 12, 3, "      colors and reverse on/off."
	Print64 13, 3, Fo(Cl%) + "Alt-F1 to Alt-F8" + Fo(Cl2%) + "------------------" + Fo(Cl3%)
	Print64 14, 3, "      Replaces C=-Number key"
	Print64 15, 3, "      combination for colors."
	Print64 16, 3, Fo(Cl%) + "Ctrl-B then a Color Code" + Fo(Cl2%) + "----------" + Fo(Cl3%)
	Print64 17, 3, "      Transmits a background color."
	Print64 21, 3, Fo(Cl5%) + "TRY experimenting with the keyboard"
	Print64 22, 3, "to get familiar with the emulation"
	Print64 23, 3, "the COMMODORE 64 keyboard..."
	Print64 25, 1, Fo(KeyCl%) + "*** Esc to exit Help, Space for More ***"
	DO
	  GetaKey Keyy$
	LOOP UNTIL Keyy$ = CHR$(27) OR Keyy$ = CHR$(13) OR Keyy$ = " "
	IF Keyy$ = CHR$(27) THEN EXIT DO
	CLS
	Print64 2, 12, Fo(TitCl%) + "Other Information"
	Print64 5, 4, Fo(Cl4%) + "For a list of DOS command-line"
	Print64 6, 4, "options, type '" + TermFile$ + " ?' in DOS."
	Print64 8, 4, "Refer to " + TermFile$ + ".DOC textfile"
	Print64 9, 4, "for more information about C= 64"
	Print64 10, 4, "keyboard emulation, as well as"
	Print64 11, 4, "other info!"
	Print64 25, 6, Fo(KeyCl%) + "*** Esc/Space to exit Help ***"
	DO
	  GetaKey Keyy$
	LOOP UNTIL Keyy$ = CHR$(27) OR Keyy$ = CHR$(13) OR Keyy$ = " "
	EXIT DO
      LOOP
      CLS
      Load64Set Set%
      Put40 1
      KeyP$ = ""
      CurBlinkTime& = 0
    CASE "-"     'Alt-X Exit 64term
      DispMsg "EXIT: Are you sure? Y/N", 7, 2, 0
      GetaKey Keyy$
      IF UCASE$(Keyy$) = "Y" THEN KeyP$ = "xx" ELSE KeyP$ = ""
      Put40 1
    END SELECT
  END IF
END SUB


FUNCTION Code64% (Char$)
  IF LEN(Char$) = 0 THEN EXIT FUNCTION
  Char% = ASC(Char$)
  IF LEFT$(Char$, 1) = CHR$(0) THEN
    Code64% = FKey%(ASC(RIGHT$(Char$, 1)))
  ELSE
    IF Tabb% = 0 THEN
      IF Char% <> 9 THEN Code64% = NormKey%(Char%) ELSE Tabb% = 1
    ELSE
      IF Char% <> 9 THEN
	Code64% = CmKey%(Char%)
	Tabb% = 0
      END IF
    END IF
  END IF
END FUNCTION

SUB CursorBlink (Status%)
  IF Status% = CurBlinkin% OR CursorEnable% = 0 THEN EXIT SUB
  IF Status% = -1 THEN
    IF CurBlinkin% = 0 THEN
      CurBlinkin% = 1
      OldCurColor% = SCREEN(Row%, Col%, 1) AND 15
      OldCurChar% = SCREEN(Row%, Col%)
      TTYStay OldCurChar% XOR 128, Colr% + Back% * 16
    ELSE
      CurBlinkin% = 0
      TTYStay OldCurChar%, OldCurColor% + Back% * 16
    END IF
  ELSEIF Status% = 0 OR Status% = 1 THEN
    IF Status% THEN
      CurBlinkin% = 1
      OldCurColor% = SCREEN(Row%, Col%, 1) AND 15
      OldCurChar% = SCREEN(Row%, Col%)
      TTYStay OldCurChar% XOR 128, Colr% + Back% * 16
    ELSE
      CurBlinkin% = 0
      TTYStay OldCurChar%, OldCurColor% + Back% * 16
    END IF
  END IF
  CurBlinkTime& = Time&
END SUB

SUB DispMsg (Msg$, MFore%, MBack%, Delay&)
  Leng% = LEN(Msg$)
  Left% = 20 - Leng% / 2
  Right% = Left% + Leng% + 1
  Get40 1
  ClearBlk 11, Left%, 13, Right%, MFore%, MBack%
  Print64 12, Left% + 1, Fo(MFore%) + Ba(MBack%) + CCap$(Msg$)
  IF Delay& THEN
    Waitt Delay&, 1        '1 second
    Put40 1
  END IF
END SUB

SUB Init64Set
  'open character set data, read it, and close the file.
  FileErr% = 0
  ON ERROR GOTO BadFile
  Temp$ = ENVIRON$(UCASE$(TermFile$))
  IF LEN(Temp$) THEN IF RIGHT$(Temp$, 1) <> "\" THEN Temp$ = Temp$ + "\"
  OPEN Temp$ + CharSetFile$ FOR INPUT AS #1
  CLOSE #1
  IF FileErr% THEN
    TCDone
    RestorePC
    PRINT
    PRINT TermName$; " can't find CHARSET.C64, the COMMODORE 64"
    PRINT "character set graphics data file. "
    PRINT
    PRINT "To fix the problem:"
    PRINT " 1. Go into the same directory where "; TermName$; "'s files are in."
    PRINT " 2. Set the '"; TermFile$; "' environment variable to indicate where "; TermName$; "'s"
    PRINT "    files are. Type the following line in DOS, or put it in AUTOEXEC.BAT:"
    PRINT "    SET "; TermFile$; "=C:\"; TermFile$
    PRINT "    Where 'C:\"; TermFile$; "' is any directory the "; TermName$; "'s files are in."
    PRINT
    PRINT "For more information, refer to "; TermFile$; ".DOC, the instructions textfile."
    END
  END IF
  FileErr% = 0
  OPEN Temp$ + CharSetFile$ FOR BINARY AS #1
  GET #1, 1, CharSet
  CLOSE #1
  Set% = 1
  Pal%(0) = 0
  Pal%(1) = 63
  Pal%(2) = 4
  Pal%(3) = 59
  Pal%(4) = 61
  Pal%(5) = 2
  Pal%(6) = 1
  Pal%(7) = 62
  Pal%(8) = 38
  Pal%(9) = 20
  Pal%(10) = 60
  Pal%(11) = 56
  Pal%(12) = 7
  Pal%(13) = 58
  Pal%(14) = 11'57
  Pal%(15) = 55
  Set64Screen
END SUB

SUB InitXLatKeys
  'This is the lookup table initialization for the function keys.
  FKey%(ASC("H")) = 145     'Cursor up
  FKey%(ASC("P")) = 17      'Cursor down
  FKey%(ASC("K")) = 157     'Cursor left
  FKey%(ASC("M")) = 29      'Cursor right
  FKey%(ASC("S")) = 20      'Backspace
  FKey%(ASC("G")) = 19      'Home
  FKey%(ASC("R")) = 148     'Insert
  FKey%(ASC("w")) = 147     'Clear home
  FKey%(ASC("^")) = 144     'Black
  FKey%(ASC("_")) = 5       'White
  FKey%(ASC("`")) = 28      'Red
  FKey%(ASC("a")) = 159     'Cyan
  FKey%(ASC("b")) = 156     'Magenta
  FKey%(ASC("c")) = 30      'Green
  FKey%(ASC("d")) = 31      'Blue
  FKey%(ASC("e")) = 158     'Yellow
  FKey%(ASC("f")) = 18      'Reverse on
  FKey%(ASC("g")) = 146     'Reverse off
  FKey%(ASC("h")) = 129     'Orange
  FKey%(ASC("i")) = 149     'Brown
  FKey%(ASC("j")) = 150     'Light Red
  FKey%(ASC("k")) = 151     'Dark Grey
  FKey%(ASC("l")) = 152     'Medium Grey
  FKey%(ASC("m")) = 153     'Light Green
  FKey%(ASC("n")) = 154     'Light Blue
  FKey%(ASC("o")) = 155     'Light Grey
  FKey%(ASC(";")) = 133     'C64's F1 key
  FKey%(ASC("<")) = 137     'C64's F2 key
  FKey%(ASC("=")) = 134     'C64's F3 key
  FKey%(ASC(">")) = 138     'C64's F4 key
  FKey%(ASC("?")) = 135     'C64's F5 key
  FKey%(ASC("@")) = 139     'C64's F6 key
  FKey%(ASC("A")) = 136     'C64's F7 key
  FKey%(ASC("B")) = 140     'C64's F8 key
  FKey%(3) = 0              'Null

  'This is the lookup table initialization for normal keys.
  FOR Keyy% = 1 TO 64        'Control characters, numbers, punctuation
    NormKey%(Keyy%) = Keyy%
  NEXT Keyy%
  NormKey%(8) = 20           'Backspace
  FOR Keyy% = 65 TO 90       'Capital letters
    NormKey%(Keyy%) = Keyy% + 128
  NEXT Keyy%
  FOR Keyy% = 91 TO 95       'Punctuation
    NormKey%(Keyy%) = Keyy%
  NEXT Keyy%
  NormKey%(96) = 95          'Left arrow character
  FOR Keyy% = 97 TO 122      'Lower case letters
    NormKey%(Keyy%) = Keyy% - 32
  NEXT Keyy%
  NormKey%(123) = 186        'Graphic char
  NormKey%(124) = 169        'Graphic char
  NormKey%(125) = 192        'Graphic char
  NormKey%(126) = 126        'PI character (tilde)
  NormKey%(127) = 148        'Insert
  FOR Keyy% = 128 TO 255     'Very infrequently used codes
    NormKey%(Keyy%) = Keyy%
  NEXT Keyy%

  'This is the lookup table initialization for COMMODORE-keypresses.
  '                   Emulated COMMODORE-key combination keypresses:
  CmKey%(64) = 164    '@' (Shift '2' on IBM)
  CmKey%(65) = 176    'A
  CmKey%(66) = 191    'B
  CmKey%(67) = 188    'C
  CmKey%(68) = 172    'D
  CmKey%(69) = 177    'E
  CmKey%(70) = 187    'F
  CmKey%(71) = 165    'G
  CmKey%(72) = 180    'H
  CmKey%(73) = 162    'I
  CmKey%(74) = 181    'J
  CmKey%(75) = 161    'K
  CmKey%(76) = 182    'L
  CmKey%(77) = 170    'M
  CmKey%(78) = 167    'N
  CmKey%(79) = 185    'O
  CmKey%(80) = 175    'P
  CmKey%(81) = 171    'Q
  CmKey%(82) = 178    'R
  CmKey%(83) = 174    'S
  CmKey%(84) = 163    'T
  CmKey%(85) = 184    'U
  CmKey%(86) = 190    'V
  CmKey%(87) = 179    'W
  CmKey%(88) = 189    'X
  CmKey%(89) = 183    'Y
  CmKey%(90) = 173    'Z
  CmKey%(91) = 164    '[' on IBM, COMMODORE '@' on C64
  CmKey%(92) = 168    '\' on IBM, COMMODORE '' on C64
  CmKey%(93) = 223    ']' on IBM, COMMODORE '*' on C64
  CmKey%(95) = 221    '_' on IBM, shift '-' on C64  (extension)
  CmKey%(45) = 220    '-' on IBM, COMMODORE '-' on C64  (extension)
  CmKey%(43) = 219    '+' on IBM, shift '+' on C64  (extension)
  CmKey%(61) = 166    '=' on IBM, COMMODORE '+' on C64  (extension)
  'The following duplicates the non-shifted ABC keys to shifted ABC keys.
  FOR CopyCm% = 96 TO 127
    CmKey%(CopyCm%) = CmKey%(CopyCm% - 32)
  NEXT CopyCm%
  CmKey%(124) = 169   '|' on IBM, shift '' on C64  (extension)
  CmKey%(13) = 141    'enter on IBM, shift-enter on C64 (extension)
  CmKey%(32) = 160    'space on IBM, shift-space on C64 (extension)
  CmKey%(8) = 20      'Backspace key on either computer (extension)
  CmKey%(14) = 142    'Switch to uppercase set (extension)
  CmKey%(ASC("1")) = 144     'Black
  CmKey%(ASC("2")) = 5       'White
  CmKey%(ASC("3")) = 28      'Red
  CmKey%(ASC("4")) = 159     'Cyan
  CmKey%(ASC("5")) = 156     'Magenta
  CmKey%(ASC("6")) = 30      'Green
  CmKey%(ASC("7")) = 31      'Blue
  CmKey%(ASC("8")) = 158     'Yellow
  CmKey%(ASC("9")) = 18      'Reverse on
  CmKey%(ASC("0")) = 146     'Reverse off

  FOR SetFoBa% = 0 TO 15
    Fo(SetFoBa%) = "{" + CHR$(SetFoBa%)
    Ba(SetFoBa%) = "}" + CHR$(SetFoBa%)
  NEXT SetFoBa%

  FOR SetIt% = 0 TO 255
    Outt%(SetIt%) = 512
  NEXT SetIt%
  FOR SetIt% = 0 TO 31
    Outt%(SetIt% + 32) = SetIt% + 32   'Punctuation, numbers, space
    Outt%(SetIt% + 64) = SetIt%        'Capital letters, and other punctuation
    Outt%(SetIt% + 96) = SetIt% + 64   'Graphic characters
    Outt%(SetIt% + 160) = SetIt% + 96  'More graphic chars
    Outt%(SetIt% + 192) = SetIt% + 64  'More graphic chars
    Outt%(SetIt% + 224) = SetIt% + 96  'More graphic chars
  NEXT SetIt%
  Outt%(255) = 191     'Graphic char
  Outt%(20) = 256      'Backspace
  Outt%(13) = 256      'Enter
  Outt%(141) = 256     'Shifted Enter
  Outt%(144) = 260     'Black
  Outt%(5) = 261       'White
  Outt%(28) = 262      'Red
  Outt%(159) = 263     'Cyan
  Outt%(156) = 264     'Purple
  Outt%(30) = 265      'Green
  Outt%(31) = 266      'Blue
  Outt%(158) = 267     'Yellow
  Outt%(129) = 268     'Orange
  Outt%(149) = 269     'Brown
  Outt%(150) = 270     'Light red
  Outt%(151) = 271     'Dark grey
  Outt%(152) = 272     'Medium grey
  Outt%(153) = 273     'Light green
  Outt%(154) = 274     'Light Blue
  Outt%(155) = 275     'Light Grey
  Outt%(17) = 257      'Cursor down
  Outt%(29) = 257      'Cursor right
  Outt%(145) = 257     'Cursor up
  Outt%(157) = 257     'Cursor left
  Outt%(18) = 258      'Reverse video on
  Outt%(146) = 258     'Reverse video off
  Outt%(148) = 258     'Insert
  Outt%(19) = 258      'Home
  Outt%(147) = 258     'Clear
  Outt%(14) = 259      'Lowercase/Uppercase char set
  Outt%(142) = 259     'Uppercase/Graphics char set
  Outt%(2) = 259       'Change background
  Outt%(7) = 259       'Bing bell noise
  Outt%(22) = 259      'Bong bell noise

END SUB

SUB Out64 (Char%)
  IF Char% = 0 THEN EXIT SUB
  Row% = CSRLIN
  Col% = POS(0)
  Temp% = Outt%(Char%)
  IF ChgBack% THEN ChgBack% = ChgBack% - 1
  IF Temp% < 256 THEN TTY Temp%: EXIT SUB
  CursorBlink 0
  SELECT CASE Temp%
  CASE 256              'Backspace, shift-return or return
    IF Char% = 20 THEN  'Backspace
      IF Col% = 1 THEN
	IF Row% > 1 THEN
	  Row% = Row% - 1
	  Col% = Wid%
	  LOCATE Row%, Col%
	  TTYStay 32, Colr% + Back% * 16
	END IF
      ELSE
	Col% = Col% - 1
	LOCATE Row%, Col%
	COLOR Colr%
	TTYStay 32, Colr% + Back% * 16
      END IF
    ELSE                'It is code 13 or 141
      AddBackScroll (Row%)
      Col% = 1
      IF Char% = 13 THEN reverse% = 0
      IF Row% < Height% THEN Row% = Row% + 1 ELSE TTYCR
    END IF
    LOCATE Row%, Col%
  CASE 260 TO 275       'Commodore color codes
    IF ChgBack% THEN
      Back% = Temp% - 260
      Background Back%
    ELSE
      Colr% = Temp% - 260
    END IF
  CASE 257              'Cursor movement
    SELECT CASE Char%
    CASE 17             'Cursor down
      IF Row% < Height% THEN Row% = Row% + 1 ELSE TTYCR
    CASE 29             'Cursor right
      IF Col% < Wid% THEN
	Col% = Col% + 1
      ELSE
	Col% = 1
	IF Row% < Height% THEN Row% = Row% + 1 ELSE TTYCR
      END IF
    CASE 145            'Cursor up
      IF Row% > 1 THEN Row% = Row% - 1
    CASE 157            'Cursor left
      IF Col% > 1 THEN
	Col% = Col% - 1
      ELSE
	IF Row% > 1 THEN Row% = Row% - 1: Col% = Wid%
      END IF
    END SELECT
    LOCATE Row%, Col%
  CASE 258              'Reverse video on/off, Insert
    SELECT CASE Char%
    CASE 148            'Insert
      IF SCREEN(Row%, 40) = 32 THEN
	GetBlock VARSEG(LineBuff), VARPTR(LineBuff), Row%, Col%, 1, 40 - Col%
	PutBlock VARSEG(LineBuff), VARPTR(LineBuff), Row%, Col% + 1, 1, 40 - Col%
	TTYStay 32, Colr% + Back% * 16
      END IF
    CASE 18, 146        'Reverse on/off
      IF Char% = 18 THEN reverse% = -1 ELSE reverse% = 0
    CASE ELSE           'Clear code 147/Home code 19
      IF NOT (Row% = 1 AND Col% = 1) THEN AddBackScroll (Row%)
      Row% = 1
      Col% = 1
      IF Char% = 147 THEN ClearBlk 1, 1, 25, 80, Colr%, Back%
      LOCATE Row%, Col%
    END SELECT
  CASE 259              'Character set changes, background color, bells
    SELECT CASE Char%
    CASE 14             'Lower/Uppercase char set
      IF Set% <> 1 THEN Set% = 1: Load64Set 1
    CASE 142            'Uppercase/Graphics char set
      IF Set% <> 0 THEN Set% = 0: Load64Set 0
    CASE 2              'Change background color initiation code
      ChgBack% = 2
    CASE ELSE           'Bell noises - Bing code 7, and Bong code 22
      IF PLAY(0) < NoteLimit% THEN IF Char% = 7 THEN PLAY Bong$ ELSE PLAY Bing$
    END SELECT
  END SELECT            'Other codes are ignored
  CurBlinkTime& = 0
END SUB

SUB PrintLoc (Msg$)
  FOR PrintChar% = 1 TO LEN(Msg$)
    Out64 Code64%(MID$(Msg$, PrintChar%, 1))
  NEXT PrintChar%
END SUB

SUB ReadCommand (Parm$)
  Para$ = " " + UCASE$(Parm$) + " "
  IF INSTR(Para$, "?") OR INSTR(Para$, "HELP") THEN
    PRINT
    PRINT TermName$; " "; Version$; " by Mark Rejhon. Parameters Help Screen"
    PRINT "Copyright "; TermDate$; ", All rights reserved."
    PRINT
    PRINT TermFile$ + " n Bxxxx ppp aaa"
    PRINT "  n........The modem's COM port number on your computer, between 1 and 4."
    PRINT "           If you omit this option, COM port 1 will be the default."
    PRINT "  Bxxxx....The baud rate you want to start "; TermName$; " in. Valid rates"
    PRINT "           are B300, B600, B1200, B2400, B4800, B9600, B19200 and B38400."
    PRINT "           If you omit this option,"; DefaultBaud&; "baud will be the default."
    PRINT "  ppp......The parameters you want to start "; TermName$; " in. Valid"
    PRINT "           parameters are 8N1 for 8 data bits, no parity, 1 stop bit, and"
    PRINT "           7E1 for 7 data bits, even parity, 1 stop bit."
    PRINT "           If you omit this option, "; DefaultParm$; " will be the default."
    PRINT "  aaa......Force EGA version or VGA version of C= 64 palette. Valid"
    PRINT "           parameters are EGA, or VGA. Default is automatic-sensing."
    PRINT
    PRINT "Example: "; TermFile$; " 2 B1200 7E1"
    PRINT "         Running this command will use the modem at COM port 2, 2400 baud,"
    PRINT "         set at 7 data bits, even parity, 1 stop bit."
    PRINT
    PRINT "Press Alt-Z while in "; TermName$; " to see a pop-up help screen."
    PRINT "For more information, refer to the "; TermFile$; ".DOC instructions textfile."
    PRINT "Thank you for trying "; TermName$; "!"
    END
  END IF
  IF INSTR(Para$, " 1 ") THEN
    Portt% = 1
  ELSEIF INSTR(Para$, " 2 ") THEN
    Portt% = 2
  ELSEIF INSTR(Para$, " 3 ") THEN
    Portt% = 3
  ELSEIF INSTR(Para$, " 4 ") THEN
    Portt% = 4
  END IF
  Test% = INSTR(Para$, " B")
  IF Test% THEN
    Test$ = MID$(Para$, Test% + 2, INSTR(Test% + 2, Para$, " ") - Test% - 2)
    SELECT CASE Test$
    CASE "300", "600", "1200", "2400", "4800", "9600", "19200", "38400"
      Baud& = VAL(Test$)
    END SELECT
  END IF
  IF INSTR(Para$, " 7E1 ") THEN
    Para$ = "7E1"
  ELSEIF INSTR(Para$, " 8N1 ") THEN
    Para$ = "8N1"
  END IF
  IF INSTR(Para$, "EGA") THEN
    PaletTest% = 1
  ELSEIF INSTR(Para$, "VGA") THEN
    PaletTest% = 2
    SavePalet
  END IF
END SUB

SUB RestorePC
  SetBordColr 0
  COLOR , 0
  CLS
  Regs.ax = &H1003
  Regs.bx = &H1
  Regs.cx = &H0
  Regs.dx = &H0
  interrupt &H10, Regs, Regs
  RestorePalet
  WIDTH 80, 25
  Regs.ax = &H3
  Regs.bx = &H0
  Regs.cx = &H0
  Regs.dx = &H0
  interrupt &H10, Regs, Regs
  LOCATE , , 1, 8, 9
  COLOR 7, 0
  CLS
END SUB

SUB Set40Mode
  WIDTH 40, 25
  Regs.ax = &H1
  Regs.bx = &H0
  Regs.cx = &H0
  Regs.dx = &H0
  interrupt &H10, Regs, Regs
  RecordScrSize 40, 25, 1, 25
END SUB

SUB Set64Palette
  IF PaletTest% = 0 THEN
    Regs.ax = &H1015
    Regs.bx = 255
    interrupt &H10, Regs, Regs
    OldCx% = Regs.cx
    OldDx% = Regs.dx
    Regs.ax = &H1010
    Regs.bx = 255
    Regs.cx = VAL("&H" + HEX$(61 * 256 + 62))
    Regs.dx = VAL("&H" + HEX$(63 * 256))
    interrupt &H10, Regs, Regs
    Regs.ax = &H1015
    Regs.bx = 255
    Regs.cx = 0
    Regs.dx = 0
    interrupt &H10, Regs, Regs
    IF (Regs.cx = (61 * 256 + 62)) AND (Regs.dx AND &HFF00) = VAL("&H" + HEX$(63 * 256)) THEN
      Regs.ax = &H1010
      Regs.bx = 255
      Regs.cx = VAL("&H" + HEX$(31 * 256 + 42))
      Regs.dx = VAL("&H" + HEX$(13 * 256))
      interrupt &H10, Regs, Regs
      Regs.ax = &H1015
      Regs.bx = 255
      Regs.cx = 0
      Regs.dx = 0
      interrupt &H10, Regs, Regs
      IF (Regs.cx = (31 * 256 + 42)) AND (Regs.dx AND &HFF00) = VAL("&H" + HEX$(13 * 256)) THEN
	PaletTest% = 2
	Regs.ax = &H1010
	Regs.bx = 255
	Regs.cx = OldCx%
	Regs.dx = OldDx%
	interrupt &H10, Regs, Regs
	SavePalet
      ELSE
	PaletTest% = 1
      END IF
    ELSE
      PaletTest% = 1
    END IF
  END IF
  IF PaletTest% = 1 THEN
    FOR Palett% = 0 TO 15
      PALETTE Palett%, Pal%(Palett%)
    NEXT Palett%
  ELSE
    FOR Palett% = 0 TO 15
      PALETTE Palett%, Palett%
    NEXT Palett%
    Palet 0, 0, 0, 0
    Palet 1, 63, 63, 63
    Palet 2, 48, 0, 0
    Palet 3, 0, 63, 63
    Palet 4, 63, 0, 63
    Palet 5, 0, 44, 0
    Palet 6, 0, 0, 48
    Palet 7, 63, 63, 0
    Palet 8, 56, 26, 0
    Palet 9, 40, 20, 0
    Palet 10, 63, 26, 26
    Palet 11, 22, 22, 22
    Palet 12, 32, 32, 32
    Palet 13, 28, 63, 28
    Palet 14, 32, 32, 63
    Palet 15, 46, 46, 46
  END IF
END SUB

SUB Set64Screen
  COLOR , 0
  CLS
  WIDTH 40, 25
  VIEW PRINT 1 TO 25
  Regs.ax = &H1200
  Regs.bx = &H30
  Regs.cx = &H0
  Regs.dx = &H0
  interrupt &H10, Regs, Regs
  Regs.ax = &H1201
  Regs.bx = &H31
  Regs.cx = &H0
  Regs.dx = &H0
  interrupt &H10, Regs, Regs
  Set40Mode
  Load64Set Set%
  'This mimics the C64 color palette.
  Regs.ax = &H1003
  Regs.bx = &H0
  Regs.cx = &H0
  Regs.dx = &H0
  interrupt &H10, Regs, Regs
  Set64Palette
  LOCATE , , 1, 9, 9
  LOCATE , , 0, 9, 9
END SUB

